from django.shortcuts import get_object_or_404, render, redirect
from django.views.decorators.http import require_GET, require_POST, require_http_methods
from .forms import *
from .models import *
from apps.orders.models import *
from django.contrib import messages
from pprint import pprint
from django.db import transaction
from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger

@require_GET
def reseller_create(request):
    form = ResellerForm()
    return render(request, 'panel/page/reseller/add_reseller.html', {'form': form})

@require_POST
def reseller_store(request):
    form = ResellerForm(request.POST)
    if form.is_valid():
        reseller = form.save()
        return redirect('reseller_show', reseller_id=reseller.id)
    return render(request, 'panel/page/reseller/add_reseller.html', {'form': form})

@require_GET
def reseller_show(request, reseller_id):
    reseller = get_object_or_404(Reseller, pk=reseller_id)
    return render(request, 'panel/page/reseller/reseller_show.html', {'reseller': reseller})

@require_GET
def reseller_edit(request, reseller_id):
    reseller = get_object_or_404(Reseller, pk=reseller_id)
    form = ResellerForm(instance=reseller)
    return render(request, 'panel/page/reseller/edit_reseller.html', {'form': form, 'reseller': reseller})

@require_POST
def reseller_update(request, reseller_id):
    reseller = get_object_or_404(Reseller, pk=reseller_id)
    form = ResellerForm(request.POST, instance=reseller)
    
    if form.is_valid():
        with transaction.atomic():
            reseller = form.save(commit=False)  # Save without committing to get the instance without saving to the database

            if reseller.status == 'approved':
                request.user.is_reseller = True
            else:
                request.user.is_reseller = False
            request.user.save()

            reseller.save()

        return redirect('reseller_request_list')

    return render(request, 'panel/page/reseller/edit_reseller.html', {'form': form, 'reseller': reseller})

@require_POST
def reseller_destroy(request, reseller_id):
    reseller = get_object_or_404(Reseller, pk=reseller_id)
    reseller.delete()
    return redirect('reseller_index')

@require_GET
def reseller_list(request):
    resellers = Reseller.objects.filter(status='approved')
    return render(request, 'panel/page/reseller/reseller_list.html', {'resellers': resellers})

@require_GET
def reseller_order_list(request):
    orders = Order.objects.filter(is_reseller = True).order_by('-id')
    return render(request, 'panel/page/reseller/reseller_order_list.html', {'orders': orders})


@require_GET
def reseller_request_list(request):
    resellers = Reseller.objects.filter(status='pending')
    return render(request, 'panel/page/reseller/reseller_request_list.html', {'resellers': resellers})

@require_GET
def reseller_request_cancel_list(request):
    resellers = Reseller.objects.filter(status='cancel')
    return render(request, 'panel/page/reseller/reseller_request_list.html', {'resellers': resellers})

def reseller_shop(request):
    products = Product.objects.filter(is_reseller = True)
    
    paginator = Paginator(products, 15)  # Show 5 products per page

    page = request.GET.get('page')
    try:
        paginated_products = paginator.page(page)
    except PageNotAnInteger:
        # If page is not an integer, deliver first page.
        paginated_products = paginator.page(1)
    except EmptyPage:
        # If page is out of range (e.g. 9999), deliver last page of results.
        paginated_products = paginator.page(paginator.num_pages)

    return render(request, 'site/page/reseller/reseller_shop.html', {'products': paginated_products})

def reseller_cart_page(request):
    return render(request, 'site/page/reseller/reseller_cart_page.html')

def reseller_checkout(request):
    return render(request, 'site/page/reseller/reseller_checkout.html')

@require_GET
def customer_reseller_create(request):
    if hasattr(request.user, 'reseller') and request.user.reseller is not None:
        return render(request, 'site/profile/reseller/submitted_request.html')
    form = ResellerRequestForm()
    return render(request, 'site/profile/reseller/add_reseller.html', {'form': form})

@require_POST
def customer_reseller_store(request):
    form = ResellerRequestForm(request.POST)
    if form.is_valid():
        reseller = form.save(commit=False)
        reseller.user = request.user
        reseller.save()
        messages.success(request, "Reseller Request Submit successfull.")
        return redirect('customer_reseller_create')
    return render(request, 'site/profile/reseller/add_reseller.html', {'form': form})

@require_GET
def customer_reseller_profile(request):
    reseller = Reseller.objects.get(user=request.user)
    pprint(vars(reseller))
    return render(request, 'site/profile/reseller/reseller_profile.html', {'reseller': reseller})


@require_GET
def customer_reseller_order_list(request):
    orders = Order.objects.filter(delivery_status='pending',is_reseller = True).order_by('-id')
    return render(request, 'site/profile/reseller/reseller_order_list.html', {'orders': orders})
