import datetime
from .models import *
from apps.customers.models import *

def create_resellers():
    resellers = [
        {
            "name": "Reseller1",
            "phone": "1234567890",
            "email": "reseller1@example.com",
            "address": "123 Main St, City",
            "details": "Leading reseller in the market",
        },
        {
            "name": "Reseller2",
            "phone": "9876543210",
            "email": "reseller2@example.com",
            "address": "456 Oak St, Town",
            "details": "Specializing in premium products",
        },
        {
            "name": "Reseller3",
            "phone": "5555555555",
            "email": "reseller3@example.com",
            "address": "789 Pine St, Village",
            "details": "Dedicated to customer satisfaction",
        },
    ]

    for reseller_data in resellers:
        # Create a CustomUser
        user = CustomUser.objects.create_user(
            phone=reseller_data["phone"],
            email=reseller_data["email"],
            password=reseller_data["phone"]
        )

        # Additional user properties can be set if needed
        user.name = reseller_data["name"]
        user.is_reseller = True
        user.save()

        Customer.objects.create(
        user=user,
        cus_full_name=reseller_data["name"],

        )

        Reseller.objects.create(
            full_name=reseller_data["name"],
            email=reseller_data["email"],
            address=reseller_data["address"],
            details=reseller_data["details"],
            status='approved',
            user=user,
        )

    print("Resellers created successfully.")
