from django.urls import path
from .views import *



urlpatterns = [
    path('compare/', compare, name='compare'),
    path('faq/', faq, name='faq'),
    path('blog_grid/', blog_grid, name='blog_grid'),
    path('blog_standard/', blog_standard, name='blog_standard'),
    path('blog_details/', blog_details, name='blog_details'),


    # ******************** product url ********************
   # Read All
    path('product_list/', product_index, name='product_list'),

    # Create
    path('create/', product_create, name='product_create'),
    path('store/', product_store, name='product_store'),

    # Read one
    path('<int:product_id>/', product_show, name='product_show'),

    # Update
    path('<int:product_id>/edit/', product_edit, name='product_edit'),
    path('<int:product_id>/update/', product_update, name='product_update'),

    # Delete
    path('<int:product_id>/destroy/', product_destroy, name='product_destroy'),


    # Read All
    path('brands/', brand_index, name='brand_index'),

    # Create
    path('brands/create/', brand_create, name='brand_create'),
    path('brands/store/', brand_store, name='brand_store'),

    # Read one
    path('brands/<int:brand_id>/', brand_show, name='brand_show'),

    # Update
    path('brands/<int:brand_id>/edit/', brand_edit, name='brand_edit'),
    path('brands/<int:brand_id>/update/', brand_update, name='brand_update'),

    # Delete
    path('brands/<int:brand_id>/destroy/', brand_destroy, name='brand_destroy'),


    # Read All
    path('categories/', category_index, name='category_index'),

    # Create
    path('categories/create/', category_create, name='category_create'),
    path('categories/store/', category_store, name='category_store'),

    # Read one
    path('categories/<int:category_id>/', category_show, name='category_show'),

    # Update
    path('categories/<int:category_id>/edit/', category_edit, name='category_edit'),
    path('categories/<int:category_id>/update/', category_update, name='category_update'),

    # Delete
    path('categories/<int:category_id>/destroy/', category_destroy, name='category_destroy'),
    
    
    

]