# views.py
from django.shortcuts import get_object_or_404, render, redirect
from django.views.decorators.http import require_GET, require_POST
from .forms import *
from .models import *
from apps.helpers import *
from django.http import JsonResponse
from django.db import transaction
from apps.products.models import *
from apps.helpers import *
from django.core.serializers import serialize
import json
from pprint import pprint

def wishlist(request):
    return render(request, 'site/page/order/wishlist.html')

def checkout(request):
    return render(request, 'site/page/order/checkout.html')

def checkout_buy_now(request, product_id):
    product = Product.objects.get(pk=product_id)
    product_serialized = serialize('json', [product])

    return render(request, 'site/page/order/checkout_buy_now.html', {'product_serialized': product_serialized })


def invoice(request, order_id):
    order = Order.objects.select_related('user').prefetch_related('orderitem_set__product').get(id=order_id)

    pprint(vars(order))
    return render(request, 'site/page/order/invoice.html', {'order': order})


@require_GET
def order_index(request):
    orders = Order.objects.filter(is_reseller = False).order_by('-id')
    return render(request, 'panel/page/order/order_list.html', {'orders': orders})

@require_GET
def order_pending_list(request):
    orders = Order.objects.filter(delivery_status='pending',is_reseller = False).order_by('-id')
    return render(request, 'panel/page/order/order_list.html', {'orders': orders})

@require_GET
def order_processing_list(request):
    orders = Order.objects.filter(delivery_status='processing',is_reseller = False).order_by('-id')
    return render(request, 'panel/page/order/order_processing_list.html', {'orders': orders})
@require_GET
def order_cancel_list(request):
    orders = Order.objects.filter(delivery_status='cancel',is_reseller = False).order_by('-id')
    return render(request, 'panel/page/order/order_cancel_list.html', {'orders': orders})
@require_GET
def order_completed_list(request):
    orders = Order.objects.filter(delivery_status='completed',is_reseller = False).order_by('-id')
    return render(request, 'panel/page/order/order_completed_list.html', {'orders': orders})

@require_GET
def order_create(request):
    form = OrderForm()
    return render(request, 'panel/page/order/add_order.html', {'form': form})

@require_POST
def order_store(request):
    form = OrderForm(request.POST)
    if form.is_valid():
        order = form.save()
        return redirect('order_show', order_id=order.id)
    return render(request, 'panel/page/order/add_order.html', {'form': form})

@require_GET
def order_show(request, order_id):
    order = Order.objects.select_related('user').prefetch_related('orderitem_set__product').get(id=order_id)
    return render(request, 'panel/page/order/order_show.html', {'order': order})

@require_GET
def order_edit(request, order_id):
    order = get_object_or_404(Order, pk=order_id)
    form = OrderForm(instance=order)
    return render(request, 'panel/page/order/edit_order.html', {'form': form, 'order': order})

@require_POST
def order_update(request, order_id):
    order = get_object_or_404(Order, pk=order_id)
    form = OrderForm(request.POST, instance=order)
    if form.is_valid():
        updated_order = form.save()

        # if updated_order.payment_status == 'paid':
        #     updated_order.user.points += updated_order.total_points
        #     updated_order.user.save()

        return redirect('order_index')
    return render(request, 'panel/page/order/edit_order.html', {'form': form, 'order': order})

from django.db import transaction

@require_POST
def order_destroy(request, order_id):
    order = get_object_or_404(Order, pk=order_id)

    with transaction.atomic():
        order_items = OrderItem.objects.filter(order=order)
        order_items.delete()

        order.delete()

    return redirect('order_index')







