# urls.py
from django.urls import path
from .views import *

urlpatterns = [

    path('wishlist/', wishlist, name='wishlist'),
    path('checkout/', checkout, name='checkout'),
    path('checkout/<int:product_id>/buy_now', checkout_buy_now, name='checkout_buy_now'),

    path('invoice/<int:order_id>', invoice, name='invoice'),

    # --------------------above site urls ------------------

    #-------------------- below is panel urls ---------------
    # Read All
    path('', order_index, name='order_index'),
    path('order_pending_list', order_pending_list, name='order_pending_list'),
    path('order_processing_list', order_processing_list, name='order_processing_list'),
    path('order_cancel_list', order_cancel_list, name='order_cancel_list'),
    path('order_completed_list', order_completed_list, name='order_completed_list'),

    # Create
    path('create/', order_create, name='order_create'),
    path('store/', order_store, name='order_store'),

    # Read one
    path('<int:order_id>/', order_show, name='order_show'),

    # Update
    path('<int:order_id>/edit/', order_edit, name='order_edit'),
    path('<int:order_id>/update/', order_update, name='order_update'),

    # Delete
    path('<int:order_id>/destroy/', order_destroy, name='order_destroy'),


]
