from datetime import datetime
from .models import *
from django.contrib.auth import get_user_model
CustomUser = get_user_model() 

def create_orders_and_items():
    user4 = CustomUser.objects.get(phone='333321321')
    user2 = CustomUser.objects.get(phone=111321321)

    order_data = {
        "id": 1,
        "full_name": 'Oleg Farmer',
        "mobile_number": '678',
        "city": 'Est occaecat non en',
        "area": 'A laboriosam occaec',
        "delivery_address": 'Sed laborum aliquam',
        "delivery_option": 'cash_in_delivery',
        "total_points": 750,
        "subtotal": 1267.98,
        "items_total": 5,
        "discount": 0,
        "total_payment": 1267.98,
        "delivery_status": 'pending',
        "payment_status": 'unpaid',
        "used_amount_from_user": 0,
        "special_discount": 0,
        "referral_commision_amount": 253.6,
        "created_at": datetime.strptime('2024-03-09 14:29:24.032197', '%Y-%m-%d %H:%M:%S.%f'),
        "updated_at": datetime.strptime('2024-03-09 14:29:24.051200', '%Y-%m-%d %H:%M:%S.%f'),
        "user": user4,
    }

    order_items_data = [
        {
            "id": 1,
            "quantity": 1,
            "price": 120,
            "points": 150,
            "color": None,
            "size": None,
            "created_at": datetime.strptime('2024-03-09 14:29:24.038201', '%Y-%m-%d %H:%M:%S.%f'),
            "updated_at": datetime.strptime('2024-03-09 14:29:24.038201', '%Y-%m-%d %H:%M:%S.%f'),
            "order_id": 1,
            "product_id": 1,
            "user": user4,
        },
        {
            "id": 2,
            "quantity": 2,
            "price": 249,
            "points": 200,
            "color": None,
            "size": None,
            "created_at": datetime.strptime('2024-03-09 14:29:24.041200', '%Y-%m-%d %H:%M:%S.%f'),
            "updated_at": datetime.strptime('2024-03-09 14:29:24.041200', '%Y-%m-%d %H:%M:%S.%f'),
            "order_id": 1,
            "product_id": 2,
            "user": user4,
        },
        {
            "id": 3,
            "quantity": 1,
            "price": 299.99,
            "points": 180,
            "color": None,
            "size": None,
            "created_at": datetime.strptime('2024-03-09 14:29:24.042198', '%Y-%m-%d %H:%M:%S.%f'),
            "updated_at": datetime.strptime('2024-03-09 14:29:24.042198', '%Y-%m-%d %H:%M:%S.%f'),
            "order_id": 1,
            "product_id": 3,
            "user": user4,
        },
        {
            "id": 4,
            "quantity": 1,
            "price": 349.99,
            "points": 220,
            "color": None,
            "size": None,
            "created_at": datetime.strptime('2024-03-09 14:29:24.043198', '%Y-%m-%d %H:%M:%S.%f'),
            "updated_at": datetime.strptime('2024-03-09 14:29:24.043198', '%Y-%m-%d %H:%M:%S.%f'),
            "order_id": 1,
            "product_id": 4,
            "user": user4,
        },
    ]

    # Create Order
    order = Order.objects.create(**order_data)

    # Create OrderItems
    for order_item_data in order_items_data:
        OrderItem.objects.create(order=order, **order_item_data)

    user4.points = 750
    user4.save()
    user4.referral.amount = 253.6
    user4.referral.save()


    print("Orders and OrderItems created successfully.")