from django.urls import path
from . import views
from .views import *


# app_name = 'core'


#create urls here
urlpatterns = [
    path('', views.index, name='home'),
    path('contact/', views.contact, name='contact'),
    path('privacy-policy/', views.privacy_policy, name='privacy-policy'),
    path('faqs/', views.faqs, name='faqs'),
    path('categories/', views.blog_category_list, name='category_list'),
    path('blogs/', views.blog_list, name='blogs'),
    path('blog_standard/', views.blog_standard, name='blog_standard'),
    path('blog/<slug:slug>/', views.blog_details, name='blog_detail'),
    path('comment/<int:comment_id>/reply/', views.reply_to_comment, name='reply_to_comment'),
    
    
    path('about/', views.about, name='about'),
    path('all_category/', views.all_category, name='all_category'),
    path('categories/<int:category_id>/', views.category_detail, name='category-detail'),
    path('product/<int:product_id>/', views.product_details, name='product_details'),
    path('shop/', views.shop, name='shop'),
    path('brand_single/', views.brand_single, name='brand_single'),
    path('brand_list/', views.brand_list, name='brand_list'),


    path('contact_list/', views.contact_list, name='contact_list'),
    path('contact/<int:contact_id>/', views.contact_detail, name='contact_detail'),
    path('contacts/<int:contact_id>/delete/', contact_delete, name='contact_delete'),

        # Read All
    path('product-sliders/', product_slider_index, name='product_slider_index'),

    # Create
    path('product-sliders/create/', product_slider_create, name='product_slider_create'),
    path('product-sliders/store/', product_slider_store, name='product_slider_store'),

    # Read one
    path('product-sliders/<int:product_slider_id>/', product_slider_show, name='product_slider_show'),

    # Update
    path('product-sliders/<int:product_slider_id>/edit/', product_slider_edit, name='product_slider_edit'),
    path('product-sliders/<int:product_slider_id>/update/', product_slider_update, name='product_slider_update'),

    # Delete
    path('product-sliders/<int:product_slider_id>/destroy/', product_slider_destroy, name='product_slider_destroy'),

    
]
