from django.core.management.base import BaseCommand
from apps.products.seed import *
from apps.customers.models import *
from apps.customers.seed import *
from apps.orders.seed import *
from apps.resellers.seed import *


from django.contrib.auth import get_user_model
CustomUser = get_user_model() 

class Command(BaseCommand):
    help = "Create brands"

    def handle(self, *args, **options):
        self.stdout.write(self.style.SUCCESS("Seeding Started ..."))

        create_super_user()
        create_users()
        create_brands()
        create_categories()
        create_products()
        seed_coupons()
        create_orders_and_items()
        create_resellers()

        self.stdout.write(self.style.SUCCESS("Seeding successfull"))




def create_super_user():
    # Create a superuser
    superuser = User.objects.create_superuser(
        phone="987987987",
        email="admin@example.com",
        password="987_admin_password"
    )

    # Additional user properties can be set if needed
    superuser.name = "Admin"
    superuser.last_name = "User"
    superuser.save()

    Customer.objects.create(
        user=superuser,
        cus_full_name=superuser.name,

    )

    print("Superuser created successfully.")


def create_users():
    # Create a User
    user111 = CustomUser.objects.create_user(
        phone="111321321",
        email="one@example.com",
        password="111321321"
    )

    # Additional user properties can be set if needed
    user111.name = "John"
    user111.last_name = "One"
    user111.save()
    Customer.objects.create(
        user=user111,
        cus_full_name=user111.name,

    )

    # Create a User
    user222 = CustomUser.objects.create_user(
        phone="222321321",
        email="two@example.com",
        password="222321321",
        referral=user111
    )

    # Additional user properties can be set if needed
    user222.name = "John2"
    user222.last_name = "Two"
    user222.save()

    Customer.objects.create(
        user=user222,
        cus_full_name=user222.name,
    )


        # Create a User
    user333 = CustomUser.objects.create_user(
        phone="333321321",
        email="333@example.com",
        password="333321321",
        referral=user111
    )

    # Additional user properties can be set if needed
    user333.name = "John3"
    user333.last_name = "3333"
    user333.save()

    Customer.objects.create(
        user=user333,
        cus_full_name=user333.name,
    )

    print("Users created successfully.")