# Generated by Django 4.2.10 on 2024-03-17 10:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='CusSetting',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('coupon_open_point', models.IntegerField(default=100)),
                ('referral_commision', models.DecimalField(decimal_places=2, default=20.0, max_digits=5)),
            ],
        ),
        migrations.CreateModel(
            name='Winner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField()),
                ('prize', models.CharField(max_length=255)),
                ('prize_paid', models.BooleanField(default=False)),
                ('prize_given_date', models.DateField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('prize_given_to', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cus_full_name', models.CharField(blank=True, max_length=100, null=True, verbose_name='Full Name')),
                ('cus_img', models.ImageField(blank=True, null=True, upload_to='customer_images/', verbose_name='Image')),
                ('cus_city', models.CharField(blank=True, max_length=50, null=True, verbose_name='City')),
                ('cus_state', models.CharField(blank=True, max_length=50, null=True, verbose_name='State')),
                ('cus_postcode', models.CharField(blank=True, max_length=50, null=True, verbose_name='Postcode')),
                ('cus_country', models.CharField(blank=True, max_length=50, null=True, verbose_name='Country')),
                ('total_purchase_amount', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=10, null=True, verbose_name='Total Purchase Amount')),
                ('ship_name', models.CharField(blank=True, max_length=100, null=True, verbose_name='Shipping Name')),
                ('ship_add', models.CharField(blank=True, max_length=100, null=True, verbose_name='Shipping Address')),
                ('ship_city', models.CharField(blank=True, max_length=100, null=True, verbose_name='Shipping City')),
                ('ship_state', models.CharField(blank=True, max_length=100, null=True, verbose_name='Shipping State')),
                ('ship_postcode', models.CharField(blank=True, max_length=100, null=True, verbose_name='Shipping Postcode')),
                ('ship_country', models.CharField(blank=True, max_length=100, null=True, verbose_name='Shipping Country')),
                ('ship_phone', models.CharField(blank=True, max_length=50, null=True, verbose_name='Shipping Phone')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.RESTRICT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Coupon',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prize', models.CharField(max_length=255)),
                ('coupon_code', models.CharField(blank=True, max_length=255, null=True)),
                ('open_date', models.DateField(blank=True, null=True)),
                ('is_enabled', models.BooleanField(default=False)),
                ('prize_paid', models.BooleanField(default=False)),
                ('expiry_date', models.DateField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('opened_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.RESTRICT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='AmountWithdraw',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('withdraw_amount', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('withdraw_method', models.CharField(blank=True, max_length=255, null=True)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('paid', 'Paid'), ('rejected', 'Rejected')], default='pending', max_length=255)),
                ('request_date', models.DateTimeField(auto_now_add=True)),
                ('is_paid', models.BooleanField(default=False)),
                ('details', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
