from django import forms
from .models import *


class CouponForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})


    class Meta:
        model = Coupon
        fields = '__all__'
        exclude = ['opened_by', 'open_date'] 
        widgets = {
            'expiry_date': forms.DateInput(attrs={'type': 'date'}),
        }





class CustomerForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})


    class Meta:
        model = Customer
        fields = '__all__'
        
        
        
class WinnerForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})


    class Meta:
        model = Winner
        fields = '__all__'
        


class AmountWithdrawForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field in self.fields.items():

            if isinstance(field, forms.ImageField):
                field.widget.attrs.update({'class': 'img-class'})  
            if isinstance(field, forms.ChoiceField): 
                field.widget.attrs.update({'class': 'choice-class'})


    class Meta:
        model = AmountWithdraw
        fields = '__all__'
        exclude = ['user','is_paid'] 

class AmountWithdrawReqForm(forms.ModelForm):
    def __init__(self, user, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.user = user

    def clean_withdraw_amount(self):
        withdraw_amount = self.cleaned_data.get('withdraw_amount')

        if withdraw_amount > self.user.amount:
            raise forms.ValidationError("Withdrawal amount cannot exceed the user's available amount.")

        return withdraw_amount

    class Meta:
        model = AmountWithdraw
        fields = '__all__'
        exclude = ['status', 'details', 'user','is_paid'] 