from django import forms
from django.contrib.auth import password_validation
from django.core.exceptions import ValidationError
from apps.customers.models import *
from django.contrib.auth import get_user_model
# Create your models here.
CustomUser = get_user_model() 

class SignupForm(forms.Form):
    name = forms.CharField(max_length=100)
    phone = forms.CharField(max_length=15)
    password1 = forms.CharField(widget=forms.PasswordInput)
    password2 = forms.CharField(widget=forms.PasswordInput)
    accept_terms = forms.BooleanField(label='Accept all the Terms & Conditions')
    referral = forms.CharField(required=False)

    def clean_password1(self):
        password1 = self.cleaned_data.get('password1')

        try:
            password_validation.validate_password(password1)
        except ValidationError as e:
            raise forms.ValidationError(e.messages[0])

        return password1

    def clean_phone(self):
        phone = self.cleaned_data.get('phone')

        if CustomUser.objects.filter(phone=phone).exists():
            raise forms.ValidationError('This phone number is already registered.')

        return phone

    def clean_referral(self):
        referral = self.cleaned_data['referral']

        if referral:
            try:
                referral = CustomUser.objects.get(phone=referral)
            except CustomUser.DoesNotExist:
                raise forms.ValidationError("Referral not found.")
            return referral

        return None

    def clean(self):
        cleaned_data = super().clean()

        # Custom overall form validation
        if not cleaned_data.get('accept_terms'):
            raise forms.ValidationError('You must accept the Terms & Conditions.')

        return cleaned_data


class CustomerForm(forms.ModelForm):
    class Meta:
        model = Customer
        fields = '__all__'
        exclude = ['total_purchase_amount','user']

# forms.py
from django import forms
from .models import CustomUser

class CustomUserForm(forms.ModelForm):
    class Meta:
        model = CustomUser
        fields = '__all__'
        exclude = ['password','last_login','user_permissions', 'groups','is_superuser','is_staff']
